/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.util.LinkedList;
import java.util.List;
import jpcsp.Allegrex.compiler.CodeInstruction;

public class CodeSequence
implements Comparable<CodeSequence> {
    private int startAddress;
    private int endAddress;
    private LinkedList<CodeInstruction> codeInstructions = new LinkedList();

    public CodeSequence(int startAddress) {
        this.startAddress = startAddress;
        this.endAddress = startAddress;
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public int getEndAddress() {
        return this.endAddress;
    }

    public void setEndAddress(int endAddress) {
        this.endAddress = endAddress;
    }

    public int getLength() {
        return (this.endAddress - this.startAddress >> 2) + 1;
    }

    public boolean isInside(int address) {
        return this.startAddress <= address && address <= this.endAddress;
    }

    public void addInstruction(CodeInstruction codeInstruction) {
        this.codeInstructions.add(codeInstruction);
    }

    public List<CodeInstruction> getInstructions() {
        return this.codeInstructions;
    }

    public CodeInstruction getCodeInstruction(int address) {
        for (CodeInstruction codeInstruction : this.codeInstructions) {
            if (codeInstruction.getAddress() != address) continue;
            return codeInstruction;
        }
        return null;
    }

    @Override
    public int compareTo(CodeSequence codeSequence) {
        int length2;
        if (codeSequence == null) {
            return -1;
        }
        int length1 = this.getLength();
        if (length1 < (length2 = codeSequence.getLength())) {
            return 1;
        }
        if (length1 > length2) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return String.format("CodeSequence 0x%X - 0x%X (length %d)", this.getStartAddress(), this.getEndAddress(), this.getLength());
    }
}

